//
//  MCMergeTokenProcessor.h
//  TokenMergeTest
//
//  Created by Alykhan Jetha on 28/10/05.
//  Copyright 2005 Marketcircle Inc.. All rights reserved.
//

#import <Cocoa/Cocoa.h>


@interface MCMergeTokenProcessor : NSObject {
	NSString *label;
	NSString *formatterClassName;
	NSString *formatterFormat;
	int formatterCode;
	
	BOOL insertCharacters;
	int insertCharacterCode; // 0 = space, 1 = newline, 2 = comma space, 3 = other
	int insertLocationCode; // 0 = in front, 1 = behind, 2 = both
	NSString *charactersToInsert;
	NSString *placeholderString;
	
	NSURL *link;
	NSMutableDictionary *extraTextAttributes;
}

@property (retain) NSURL *link;
@property (retain) NSMutableDictionary *extraTextAttributes;

- (void)encodeWithCoder:(NSCoder *)coder;
- (id)initWithCoder:(NSCoder *)coder;


- (NSString *)label;
- (void)setLabel:(NSString *)aLabel;

- (NSString *)formatterClassName;
- (void)setFormatterClassName:(NSString *)aFormatterClassName;

- (NSString *)formatterFormat;
- (void)setFormatterFormat:(NSString *)aFormatterFormat;

- (int)formatterCode;
- (void)setFormatterCode:(int)aFormatterCode;

- (NSString *)displayName;
- (NSString *)inspectorClassName;

- (BOOL)insertCharacters;
- (void)setInsertCharacters:(BOOL)flag;

- (int)insertCharacterCode;
- (void)setInsertCharacterCode:(int)anInsertCharacterCode;

- (int)insertLocationCode;
- (void)setInsertLocationCode:(int)anInsertLocationCode;

- (NSString *)charactersToInsert;
- (void)setCharactersToInsert:(NSString *)aVal;

- (BOOL)takesExtraCharacters;

// creates a NSURL and sets it
- (void)setLinkFromString:(NSString *)aSTRUrl;

// adds to the extraTextAttributes dictionary. The value is cleared if obj is nil.
- (void)setValue:(id)obj forExtraTextAttributeName:(NSString *)aAttributeName;


- (id)rawValueFromObject:(id)obj arguments:(id)args;

- (id)valueFromObject:(id)obj arguments:(id)args applyFormatter:(BOOL)applyFormatter;

// anObjThatResponds should respond to formatterForFormatCode. If nil is passed, then the default formatter manager is used
- (id)valueFromObject:(id)obj arguments:(id)args applyFormatter:(BOOL)applyFormatter formatterCodeProvidor:(id)anObjThatResponds;

@end
